/******************** NewIconWP.rexx *********************/
/*                                                       */
/*             Copyright 1993 by Dave Senger             */
/*                                                       */
/*                       Oct. 5/93                       */
/*                                                       */
/*   Please keep my name, this notice, and all comments, */
/* intact in any distribution of this program, in whole  */
/* or in part.                                           */
/*                                                       */
/*********************************************************/

/*********************** U S A G E ***********************/
/*                                                       */
/*   Make sure you have at least one backup of your wp   */
/* load file.  CD a Shell to the directory containing    */
/* wp, and enter the command, "rx NewIconWP", without    */
/* the quotes.  When prompted, enter `wp', then enter    */
/* complete pathname and file name of icon .info file    */
/* you want to use.  You should get a message saying     */
/* that the job is done.  Test patch by running          */
/* WordPerfect and saving a dummy file.  Attached icon   */
/* should look like icon you used.  There are only 416   */
/* bytes of space for bitplanes in the wp load file, so  */
/* only moderately-sized icons can be used.  Script      */
/* won't let you use an icon whose bitplanes are too     */
/* big.  You can check your icon beforehand by running   */
/* it through PrintIconBitplanes.rexx, then printing the */
/* output file, `FirstHexBitplanes', in RAM:.            */
/*                                                       */
/*********************************************************/

/*   Changes document icon generated by WordPerfect */
/* 4.1.12, 4.1.11, <4.1.10 ??>, or 4.1.9 wp load file, */
/* by replacing two image bitplanes with two bitplanes */
/* from an icon of your choice, and by editing width & */
/* height words in Gadget and Image structures, to match */
/* the equivalent values in the icon.  */

/*    If you have 4.1.10, then you also have 4.1.9.  If */
/* last 800 or so bytes of both load files are */
/* identical, this patch will work on 4.1.10.  Edit */
/* ELSE IF code line below as directed, then patch */
/* your 4.1.10 load file.  Better yet, write for your */
/* free 4.1.12 upgrade to:                            */
/*
      Macintosh Customer Support, G100
      WordPerfect Corporation
      1555 N. Technology Way
      OREM Utah 84057
*/
/* Be sure to include your WordPerfect license number.  */


PARSE ARG wpfile infofile
wpfile=STRIP(wpfile)             /* Strip spaces from each end */
infofile=STRIP(infofile)

DO WHILE wpfile=''
   SAY
   SAY "Enter pathname/file name of `wp' load "||,
       "file (<RETURN> to quit):"
   OPTIONS PROMPT " >>>-- "
   PARSE PULL wpfile
   wpfile=STRIP(wpfile)          /* Strip spaces from each end */
   IF wpfile='' THEN EXIT 0
   END

IF ~OPEN('patchfile',wpfile) THEN DO /* Try to open wp */
   SAY "Can't find `wp'.  Sorry, no can do!"
   EXIT 20                       /* If no wp, quit */
   END
x=STATEF(wpfile)                 /* Get file attributes */
PARSE VAR x type size remainder  /* Pick out file size, -- */
IF size=116528 THEN              /* -- and set offset -- */
   offset=-510  /* wp 4.1.12 */  /* -- to match version */

/*    If size of wp 4.1.10 load file is known, replace */
/* next code line with edited line, substituting number */
/* of bytes in 4.1.10 wp for <size of wp 4.1.10>. */
/* ELSE IF size=114728 | size=<size of wp 4.1.10> | size=105396 THEN */

ELSE IF size=114728 | size=105396 THEN
   offset=-498  /* wp 4.1.11 <or 4.1.10> or 4.1.9 */
ELSE DO
   SAY "I don't recognize this file.  Sorry!"
   x=CLOSE('patchfile')          /* If wrong size -- */
   EXIT 0                        /* -- close and quit */
   END

DO WHILE infofile=''
   SAY
   SAY "   Enter full pathname and file name of .info file whose"
   SAY "bitplanes you want to copy to wp load "||,
       "file (<RETURN> to quit)."
   SAY
   OPTIONS PROMPT " >>>-- "
   PARSE PULL infofile
   infofile=STRIP(infofile)      /* Strip spaces from each end */
   IF infofile='' THEN DO
      x=CLOSE('patchfile')
      EXIT 0
      END
   END

IF UPPER(RIGHT(infofile,5))~='.INFO' THEN DO
   SAY
   SAY "File name must have a .info suffix.  Try again."
   x=CLOSE('patchfile')
   EXIT 20
   END

IF ~OPEN('infile',infofile) THEN DO /* Try to open specified file */
   SAY
   SAY "Can't find `"infofile"'.  Sorry, no can do!"
   x=CLOSE('patchfile')
   EXIT 20
   END

magic=READCH('infile',2)     /* Start of DiskObject structure */
IF magic~=X2C(E310) THEN DO  /* If not icon .info file, quit */
   SAY
   SAY "`"infofile"' is not a true icon .info file."
   x=CLOSE('patchfile')
   x=CLOSE('infile')
   EXIT 20
   END

x=SEEK('infile',10)          /* Gadget structure embedded -- */
gg_width=C2D(READCH('infile',2))
gg_height=C2D(READCH('infile',2))
flags=READCH('infile',2)     /* -- in DiskObject structure */
GADGHIMAGE=BITTST(flags,1)   /* Dual-image icon?? */
GADGBACKFILL=BITTST(flags,0) /* Backfill or complement?? */

WBDISK=1
WBDRAWER=2
WBGARBAGE=5
x=SEEK('infile',30)          /* DiskOjbect structure */
type=C2D(READCH('infile',1)) /* Does icon open window?? */
IF type=WBDISK | type=WBDRAWER | type=WBGARBAGE THEN window=1
ELSE window=0
x=SEEK('infile',17)          /* DrawerData structure exist?? */
do_DrawerData=C2D(READCH('infile',4))

/* If icon opens a window when double-clicked on, */
/* or even if it doesn't open a window, but */
/* contains a DrawerData structure, then SEEK */
/* past DrawerData structure and into Image structure.  */
/* Else, just SEEK into Image structure. */

IF window | do_DrawerData~=0 THEN x=SEEK('infile',68)
ELSE x=SEEK('infile',12)     /* SEEK to 3rd word of 1st -- */
CALL ReadImageStructure()    /* -- Image structure, then read */
IF bpLength>208 THEN DO
   SAY
   SAY "Bitplanes are each "bpLength" bytes long.  Max. is 208 bytes."
   SAY "Sorry, no can do."
   x=CLOSE('patchfile')
   x=CLOSE('infile')
   EXIT 20
   END
IF depth>1 THEN CALL Copy2()
ELSE DO
   SAY
   SAY "Only one bitplane.  Sorry, no can do."
   x=CLOSE('patchfile')
   x=CLOSE('infile')
   EXIT 20
   END

x=CLOSE('infile')            /* Close input .info file  */

x=SEEK('patchfile',offset-98,'end')  /* Set file pointer */
x=WRITECH('patchfile',D2C(gg_width,2))  /* Gadget structure embedded -- */
x=WRITECH('patchfile',D2C(gg_height,2)) /* -- in DiskObject structure */

wpGflags=READCH('patchfile',2)       /* Read wp Gadget flags word */
IF GADGHIMAGE THEN wpGflags=BITSET(wpGflags,0) /* Restore wp's default comp. mode */
ELSE DO                              /* If icon being copied -- */
   IF GADGBACKFILL THEN wpGflags=BITSET(wpGflags,0)
   ELSE wpGflags=BITCLR(wpGflags,0)  /* -- isn't dual-image, give wp -- */
   END                               /* -- same complement mode as icon */

x=SEEK('patchfile',-2)               /* Set file pointer */
x=WRITECH('patchfile',wpGflags)      /* Replace edited flags word */

x=SEEK('patchfile',offset-28,'end')  /* Set file pointer */
x=WRITECH('patchfile',D2C(width,2))  /* Image structure */
x=WRITECH('patchfile',D2C(height,2))

x=SEEK('patchfile',offset,'end') /* Set file pointer */
x=WRITECH('patchfile',a)         /* Write bitplanes */
x=WRITECH('patchfile',b)

x=CLOSE('patchfile')             /* Close patched wp file -- */
SAY "That gets it.  So long!"    /* -- and get out */
EXIT 0

ReadImageStructure:

   width=C2D(READCH('infile',2)) /* 3rd word of Image structure */
   height=C2D(READCH('infile',2))
   depth=C2D(READCH('infile',2))
   wordWidth=(width+15)%16
   bpLength=wordWidth*height*2
   RETURN

Copy2:

   x=SEEK('infile',10)          /* SEEK past end of Image structure */
   a=READCH('infile',bpLength)  /* Read 2 bitplanes */
   b=READCH('infile',bpLength)
   RETURN
